<!-- Main content -->
<x-admin.contents>
    <x-slot:title>{{ $data['title'] }}</x-slot:title>
    <x-slot:menuOpen>{{ $data['menuOpen'] }} </x-slot:menuOpen>
    <x-slot:menuActive>{{ $data['menuActive'] }} </x-slot:menuActive>
    <x-slot:page>{{ $data['page'] }}</x-slot:page>
    <x-slot:head>
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/sweetalert2/sweetalert2.min.css">
    </x-slot:head>


    <section class="content">

        <!-- Default box -->
        <div class="row">
            <div class="col-lg-8">
                <x-message></x-message>
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fa fa-server text-primary"></i> {{ $data['page'] }}</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered table-hover myTable tab">
                            <thead>
                                <tr>
                                    <th width="5%">No</th>
                                    <th>Nama Bank</th>
                                    <th>Atas Nama</th>
                                    <th>No. Rek</th>
                                    <th>Tgl. Input</th>
                                    <th width="20%">Opsi</th>
                                </tr>
                            </thead>
                            <tbody id="view">
                                @forelse ($bank as $b)
                                    <tr>
                                        <td class="text-center">{{ $no++ }}</td>
                                        <td>{{ $b->judul }}</td>
                                        <td>{{ $b->link }}</td>
                                        <td>{{ $b->isi }}</td>
                                        <td>{{ tgl_inf($b->created_at) }} </td>
                                        <td class="text-center">
                                            <button class="btn btn-primary btn-sm mb-0 mt-0 edit"
                                                data-id="{{ $b->id }}" data-toggle="modal"
                                                data-target="#edit{{ $b->id }}">
                                                <i class="fa fa-edit mr-2"></i> Edit
                                            </button>
                                            <button class="btn btn-danger btn-sm mb-0 mt-0 hapus"
                                                data-id="{{ $b->id }}" data-nm="{{ $b->judul }}">
                                                <i class="fa fa-trash mr-1"></i> Hapus
                                            </button>

                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="10" class="text-center">Data masih kosong</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title "><i class="fa fa-database text-primary"></i> Input {{ $data['page'] }}
                        </h3>
                    </div>
                    <form action="{{ route('bank.tambah') }}" method="post">
                        @csrf
                        <div class="card-body">
                            @csrf
                            <div class="form-group">
                                <label>Nama Bank</label>
                                <input type="text" name="nama_bank" class="form-control" placeholder="Nama Bank"
                                    autofocus required value="{{ old('nama_bank') }}">
                                @error('nama_bank')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label>Atas Nama</label>
                                <input type="text" name="atas_nama" class="form-control" placeholder="Atas nama"
                                    required value="{{ old('atas_nama') }}">
                                @error('atas_nama')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label>No Rekening</label>
                                <input type="text" name="no_rek" class="form-control numbers"
                                    placeholder="No Rekening" required value="{{ old('no_rek') }}">
                                @error('no_rek')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="reset" class="btn btn-default"><i class="fa fa-sync-alt"></i>
                                Reset</button>
                            <button class="btn btn-primary float-right"><i class="fa fa-save"></i> Simpan</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <!-- /.card -->

    </section>

    @foreach ($bank as $u)
        <div class="modal fade" id="edit{{ $u->id }}">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header bg-primary ">
                        <h4 class="modal-title">Edit Data</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="{{ route('bank.edit') }}" method="POST">
                        <div class="modal-body">
                            @csrf
                            @method('put')
                            <input type="hidden" name="id" id="" value="{{ $u->id }}">
                            <input type="hidden" name="nmlama" id="" value="{{ $u->judul }}">
                            <div class="form-group">
                                <label>Nama Bank</label>
                                <input type="text" name="nama_bank" class="form-control" placeholder="Nama Bank"
                                    autofocus required value="{{ $u->judul }}">
                                @error('nama_bank')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label>Atas Nama</label>
                                <input type="text" name="atas_nama" class="form-control" placeholder="Atas nama"
                                    required value="{{ $u->link }}">
                                @error('atas_nama')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label>No Rekening</label>
                                <input type="text" name="no_rek" class="form-control" placeholder="No Rekening"
                                    required value="{{ $u->isi }}">
                                @error('no_rek')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>

                        </div>
                        <div class="modal-footer justify-content-between">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Simpan</button>
                        </div>
                    </form>
                </div>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>
    @endforeach

    <x-slot:foot>
        <script src="{{ asset('') }}assets/admin/plugins/sweetalert2/sweetalert2.all.min.js"></script>
        <script>
            $('#view').on('click', '.hapus', function() {
                var id = $(this).attr('data-id');
                var nama = $(this).attr('data-nm');

                Swal.fire({
                    title: "Apa anda yakin?",
                    text: "Rekening Bank  ( " + nama +
                        " ) & data yang berkaitan dengan Data tersebut akan di hapus!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#3085d6",
                    cancelButtonColor: "#d33",
                    confirmButtonText: "Ya, Hapus!"
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.location.href = "delete-bank/" + id;
                    }
                });

            });
        </script>
    </x-slot:foot>
</x-admin.contents>
